 /*!
 * Copyright (c) 2005, Freescale Semiconductor
 *
 * Freescale Confidential Proprietary
 * \file    drivers.h
 * \brief   This is the SMAC C source driver header file for the HCS08 MCU
 * and MC13192 transceiver.  
 * \author  a19259
 * \version 4.1a
 * \date    2005/07/29 02:27:50 
 * 
 * \b Description:
 *
 * The header defines all externals, prototypes and 
 * MC13192 status mask bits used by the actual C driver.
 *
 * \b Department: Freescale Radio Products Division 
 *
 * \b Project: SMAC (Simple Media Access Controller)
 *
 * \b History:
 * - 16/11/2005 Doc. update to Doxygen compliant by Mario Rodriguez r12369c
 */ 
 
#ifndef _DRIVERS_H
#define _DRIVERS_H

#include "hprfgw_config.h"
//#include "derivative.h"
#include "smac_pub_def.h"

/* Externals */
extern volatile UINT8 gu8RTxMode;            //!< Global mode mirror.
/* Default TxPktLen reserved bits so that we do not need to read from spi
 * before each transmit. */
extern UINT16 gu8TxPktLenDefault;
extern tRxPacket *psDrvRxPacket;           //!< Where the packet received will be stored
extern UINT32 Rfdiags_numCCA_TxDone;

/* Defines */
#define TX_IRQ_MASK         0x0040  /*!< Transmit IRQ Mask */
#define ARBERR_IRQ_MASK     0x2000  /*!< RAM add error IRQ Mask */
#define RAMERR_IRQ_MASK     0x4000  /*!< RAM add error IRQ Mask */
#define RX_IRQ_MASK         0x0080  /*!< Receive IRQ Mask */
#define ATTN_IRQ_MASK       0x0400  /*!< Attention IRQ Mask */
#define CRC_VALID_MASK      0x0001  /*!< CRC valid Mask */
#define TIMER1_IRQ_MASK     0x0100  /*!< Timer1 IRQ Mask */
#define XCVR_SEQ_MASK       0xFFF8  /*!< Transceiver seq mask */
#define LO_LOCK_IRQ_MASK    0x8000  /*!< Lo lock IRQ Mask */
#define CCA_IRQ_MASK        0x0020  /*!< CCA IRQ Mask */
#define DOZE_IRQ_MASK       0x0200  /*!< Doze IRQ Mask */
#define RESET_BIT_MASK      0x0080  /*!< Reset bit Mask */
#define CCA_BIT_MASK        0x0002

/* Prototypes */


extern void RTXENDeAssert(void) ;      
extern void RTXENAssert(void);         
extern void MC13192Wake(void);  
extern UINT8 IRQPinLow(void);

extern void SPIClearRecieveStatReg(UINT8 * u8TempValue);    
extern void SPIClearRecieveDataReg(UINT8 * u8TempValue);    
extern void SPISendChar(UINT8 u8Char);         
#if defined (OS_NUCLEUS)
 extern UINT8 SPIRead(void);
#endif
extern void SPIReadMSB(UINT16 * u16Data);                
extern void SPIReadLSB(UINT16 * u16Data);      

#ifdef  __cplusplus
extern "C" 
{
#endif

void MC13192_HISR(void);
void MC13192_LISR(int vector_num);
void MC13192_MiniISRForACK(void);
#if defined (OS_WINCE)
 DWORD HPR_IntrThread(VOID *pContext);
#endif

#ifdef  __cplusplus
}
#endif

//#define PROFILE_CODE  (1)

#if PROFILE_CODE

// Debug structure to timestamp code
typedef struct _DebugTimeStampStruct
{
  UINT32 packetIndex;
  UINT32 TxStateTimeStamp;
  UINT32 PktWriteTimeStamp;
  UINT32 CCADoneTimeStamp;
  UINT32 TxDoneTimeStamp;
  UINT32 TxTimeoutAckTimeStamp;
  UINT32 TxRecvAckTimeStamp;
  UINT32 RxStartTimeStamp;
  UINT32 RxRecvdTimeStamp;
  UINT32 RxTxAckTimeStamp;
}DebugTimeStampStruct;


#define PROFILE_MAX_COUNT   (4*1024*4)
extern UINT32 recvCnt;
extern UINT32 Rfdiags_LowLevelTxPacketCnt;
extern UINT8  u8RetryNo;
extern DebugTimeStampStruct CodeProfileLog[PROFILE_MAX_COUNT];

  #if defined(OS_LINUX)
    #define HPRF_PROFILE(NAME) \
      trace_printk("%s pktcnt=%lu retry=%hhu\n", #NAME, Rfdiags_LowLevelTxPacketCnt, u8RetryNo);
    #define HPRF_PROFILE_PKT_INDEX() \
      trace_printk("pkt index=%lu\n", Rfdiags_LowLevelTxPacketCnt);

  #else
    #define HPRF_PROFILE_INDEX() \
      (((Rfdiags_LowLevelTxPacketCnt<<2)|(u8RetryNo&0x3))%PROFILE_MAX_COUNT)
    #define HPRF_PROFILE(NAME) \
      (CodeProfileLog[HPRF_PROFILE_INDEX()].NAME##TimeStamp = CURRENT_TIME_STAMP)
    #define HPRF_PROFILE_PKT_INDEX() \
      (CodeProfileLog[HPRF_PROFILE_INDEX()].packetIndex = Rfdiags_LowLevelTxPacketCnt)

  #endif //OS_LINUX
#else

  #define HPRF_PROFILE(NAME)
  #define HPRF_PROFILE_PKT_INDEX()

#endif // PROFILE_CODE


#if defined (OS_NUCLEUS)
typedef struct
{
    NU_HISR RfPhyHISR;
    UINT8   RfPhyHISRStack[16*1024];    
} RFPHYISRSTRUCT;
extern RFPHYISRSTRUCT RFPhyISR;
#endif

extern UINT32 Rfdiags_LowLevelInvalidRxPacketCnt;

#endif /* _DRIVERS_H */
